<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - {{ $transaction->package->name }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #1E1E1E;
        }

        .receipt-container {
            max-width: 800px;
            margin: 40px auto;
            padding: 40px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
        }

        .receipt-header {
            border-bottom: 3px solid #4B8BFF;
            padding-bottom: 30px;
            margin-bottom: 30px;
            display: table;
            width: 100%;
        }

        .company-info {
            display: table-cell;
            vertical-align: top;
            width: 50%;
        }

        .company-name {
            font-size: 32px;
            font-weight: bold;
            color: #4B8BFF;
            margin-bottom: 10px;
        }

        .company-details {
            color: #666;
            font-size: 14px;
            line-height: 1.8;
        }

        .receipt-info {
            display: table-cell;
            vertical-align: top;
            width: 50%;
            text-align: right;
        }

        .receipt-title {
            font-size: 28px;
            font-weight: bold;
            color: #333;
            margin-bottom: 15px;
        }

        .receipt-meta {
            color: #666;
            font-size: 14px;
            line-height: 1.8;
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            margin-bottom: 15px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }

        .customer-info {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #4B8BFF;
        }

        .customer-info h4 {
            color: #333;
            margin-bottom: 10px;
            font-size: 16px;
        }

        .customer-details {
            display: table;
            width: 100%;
        }

        .customer-details .detail-item {
            display: table-row;
        }

        .customer-details .label,
        .customer-details .value {
            display: table-cell;
            padding: 5px 0;
            vertical-align: top;
        }

        .customer-details .label {
            font-weight: 600;
            color: #555;
            width: 150px;
        }

        .customer-details .value {
            color: #333;
        }

        .package-section {
            background-color: #f8f9fa;
            padding: 25px;
            border-radius: 8px;
            border: 1px solid #dee2e6;
        }

        .package-header {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .package-info {
            display: table-cell;
            vertical-align: top;
            width: 70%;
        }

        .package-name {
            font-size: 20px;
            font-weight: bold;
            color: #333;
            margin-bottom: 5px;
        }

        .package-type {
            color: #4B8BFF;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 12px;
            background-color: rgba(75, 139, 255, 0.1);
            padding: 4px 8px;
            border-radius: 4px;
            display: inline-block;
            margin-bottom: 10px;
        }

        .package-description {
            color: #666;
            font-size: 14px;
            line-height: 1.6;
        }

        .package-price {
            display: table-cell;
            vertical-align: top;
            width: 30%;
            text-align: right;
        }

        .price-amount {
            font-size: 24px;
            font-weight: bold;
            color: #28a745;
        }

        .features-list {
            margin-top: 20px;
        }

        .features-list h5 {
            color: #333;
            margin-bottom: 10px;
            font-size: 14px;
            font-weight: 600;
        }

        .features-list ul {
            list-style: none;
            padding: 0;
        }

        .features-list li {
            padding: 5px 0;
            color: #555;
            font-size: 14px;
            position: relative;
            padding-left: 20px;
        }

        .features-list li:before {
            content: "✓";
            color: #28a745;
            font-weight: bold;
            position: absolute;
            left: 0;
            top: 5px;
        }

        .transaction-details {
            background-color: #fff;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            overflow: hidden;
        }

        .transaction-details table {
            width: 100%;
            border-collapse: collapse;
        }

        .transaction-details th,
        .transaction-details td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #dee2e6;
        }

        .transaction-details th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #555;
            font-size: 14px;
        }

        .transaction-details td {
            color: #333;
            font-size: 14px;
        }

        .transaction-details tr:last-child th,
        .transaction-details tr:last-child td {
            border-bottom: none;
        }

        .payment-summary {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            border-left: 4px solid #28a745;
        }

        .payment-breakdown {
            margin-bottom: 15px;
        }

        .payment-item {
            display: table;
            width: 100%;
            margin-bottom: 8px;
        }

        .payment-item .label,
        .payment-item .value {
            display: table-cell;
            vertical-align: top;
        }

        .payment-item .label {
            color: #555;
            font-size: 14px;
        }

        .payment-item .value {
            text-align: right;
            font-weight: 600;
            color: #333;
            font-size: 14px;
        }

        .payment-item.total {
            border-top: 2px solid #28a745;
            padding-top: 10px;
            margin-top: 15px;
        }

        .payment-item.total .label {
            font-weight: bold;
            color: #333;
            font-size: 16px;
        }

        .payment-item.total .value {
            font-size: 18px;
            color: #28a745;
            font-weight: bold;
        }

        .payment-item.discount .value {
            color: #dc3545;
        }

        .payment-item.original .value {
            text-decoration: line-through;
            color: #6c757d;
        }

        .coupon-info {
            background-color: rgba(255, 193, 7, 0.1);
            border: 1px solid #ffc107;
            border-radius: 4px;
            padding: 8px 12px;
            margin-top: 10px;
            font-size: 12px;
            color: #856404;
        }

        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #dee2e6;
            text-align: center;
            color: #6c757d;
            font-size: 12px;
            line-height: 1.8;
        }

        .status-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
        }

        .status-badge.completed {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }

        .thank-you {
            background-color: #e7f3ff;
            border: 1px solid #4B8BFF;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            margin: 30px 0;
        }

        .thank-you h3 {
            color: #4B8BFF;
            margin-bottom: 10px;
            font-size: 18px;
        }

        .thank-you p {
            color: #555;
            font-size: 14px;
            line-height: 1.6;
        }

        @media print {
            .receipt-container {
                padding: 20px;
            }
            
            .receipt-header {
                page-break-inside: avoid;
            }
            
            .section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="receipt-header">
            <div class="company-info">
                <div class="company-name">{{ $company['name'] }}</div>
                <div class="company-details">
                    Website: {{ $company['website'] }}
                </div>
            </div>
            <div class="receipt-info">
                <div class="receipt-title">RECEIPT</div>
                <div class="receipt-meta">
                    <strong>Receipt #:</strong> {{ $transaction->id }}<br>
                    <strong>Date:</strong> {{ $transaction->created_at->format('F d, Y') }}<br>
                    <strong>Time:</strong> {{ $transaction->created_at->format('H:i') }}<br>
                    <strong>Status:</strong> <span class="status-badge completed">{{ ucfirst($transaction->status) }}</span>
                </div>
            </div>
        </div>

        <!-- Customer Information -->
        <div class="section">
            <div class="section-title">Customer Information</div>
            <div class="customer-info">
                <h4>Purchase Details</h4>
                <div class="customer-details">
                    <div class="detail-item">
                        <div class="label">Customer Name:</div>
                        <div class="value">{{ $transaction->user->name }}</div>
                    </div>
                    <div class="detail-item">
                        <div class="label">SteamID64:</div>
                        <div class="value">{{ $transaction->user->steamid ?? 'Not Available' }}</div>
                    </div>
                    @if($transaction->server)
                    <div class="detail-item">
                        <div class="label">Server:</div>
                        <div class="value">{{ $transaction->server->name }}</div>
                    </div>
                    @endif
                    <div class="detail-item">
                        <div class="label">Payment Method:</div>
                        <div class="value">{{ $transaction->payment_method_display }}</div>
                    </div>
                    @if($transaction->transaction_id)
                    <div class="detail-item">
                        <div class="label">Transaction ID:</div>
                        <div class="value">{{ $transaction->transaction_id }}</div>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Package Information -->
        <div class="section">
            <div class="section-title">Package Details</div>
            <div class="package-section">
                <div class="package-header">
                    <div class="package-info">
                        <div class="package-name">{{ $transaction->package->name }}</div>
                        <div class="package-type">{{ $transaction->package->type }} Package</div>
                        <div class="package-description">{{ $transaction->package->description }}</div>
                    </div>
                    <div class="package-price">
                        <div class="price-amount">{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->amount, 2) }}</div>
                    </div>
                </div>

                @if($transaction->package->features && count($transaction->package->features) > 0)
                <div class="features-list">
                    <h5>Package Features:</h5>
                    <ul>
                        @foreach($transaction->package->features as $feature)
                            <li>{{ $feature }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
            </div>
        </div>

        <!-- Transaction Details -->
        <div class="section">
            <div class="section-title">Transaction Details</div>
            <div class="transaction-details">
                <table>
                    <thead>
                        <tr>
                            <th>Description</th>
                            <th>Details</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Package Name</td>
                            <td>{{ $transaction->package->name }}</td>
                        </tr>
                        <tr>
                            <td>Package Type</td>
                            <td>{{ ucfirst($transaction->package->type) }}</td>
                        </tr>
                        <tr>
                            <td>Purchase Date</td>
                            <td>{{ $transaction->created_at->format('F d, Y \a\t H:i') }}</td>
                        </tr>
                        @if($transaction->updated_at != $transaction->created_at)
                        <tr>
                            <td>Completion Date</td>
                            <td>{{ $transaction->updated_at->format('F d, Y \a\t H:i') }}</td>
                        </tr>
                        @endif
                        <tr>
                            <td>Payment Method</td>
                            <td>{{ $transaction->payment_method_display }}</td>
                        </tr>
                        @if($transaction->server)
                        <tr>
                            <td>Server</td>
                            <td>{{ $transaction->server->name }}</td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Payment Summary -->
        <div class="section">
            <div class="section-title">Payment Summary</div>
            <div class="payment-summary">
                <div class="payment-breakdown">
                    @if($transaction->discount_amount > 0)
                    <div class="payment-item original">
                        <div class="label">Original Price:</div>
                        <div class="value">{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->original_amount, 2) }}</div>
                    </div>
                    <div class="payment-item discount">
                        <div class="label">
                            Discount Applied:
                            @if($transaction->coupon)
                                ({{ $transaction->coupon->code }})
                            @endif
                        </div>
                        <div class="value">-{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->discount_amount, 2) }}</div>
                    </div>
                    @endif
                    
                    <div class="payment-item total">
                        <div class="label">Total Paid:</div>
                        <div class="value">{{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->amount, 2) }}</div>
                    </div>
                </div>

                @if($transaction->discount_amount > 0)
                <div class="coupon-info">
                    💰 You saved {{ currency_symbol(config_value('store_currency', 'GBP')) }}{{ number_format($transaction->discount_amount, 2) }} ({{ $transaction->discount_percentage }}%) on this purchase!
                </div>
                @endif
            </div>
        </div>

        <!-- Thank You Message -->
        <div class="thank-you">
            <h3>Thank You for Your Purchase!</h3>
            <p>
                Your purchase has been successfully processed and your in-game benefits should be available within a few minutes. 
                If you experience any issues or need support, please contact our team with your transaction ID: <strong>{{ $transaction->transaction_id ?? $transaction->uuid }}</strong>
            </p>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>
                This is an official receipt for your purchase from {{ $company['name'] }}.<br>
                Generated on {{ now()->format('F d, Y \a\t H:i') }}
            </p>
            <p>
                For support or questions about this purchase, please visit {{ $company['website'] }}.
            </p>
        </div>
    </div>
</body>
</html>